PSCAD 4.2.0

Settings
 {
 Id = "922686631.1144361550"
 Author = "reform.jayas"
 Desc = "Active Filter - parallel configuration"
 Arch = "windows"
 Options = 0
 Build = 22
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 1e-005
  Plot = 1e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "Workshop3.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 50.0 [Hz]
  }

 }

Definitions
 {
 Component("AlphaBeta_ABC")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Parameters")
    {
    Choice("Mode",6,2,180,12,2)
     {
     Style = 0
     Desc = "Direction of Transformation:"
     Def = "0"
     Len = 15
     *0 = "ABC to AlphaBeta"
     *1 = "AlphaBeta to ABC"
     }
    Choice("Zero",6,16,180,12,2)
     {
     Style = 0
     Desc = "With Zero-Sequence Component"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    }
   }

  Nodes = 
   {
   Input("IALP",-72,-36)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Input("IBET",-72,0)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Input("ZER",-72,36)
    {
    Cond = "(Mode) && (Zero)"
    Type = Real
    }
   Output("IA",72,-36)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Output("IB",72,0)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Output("IC",72,36)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Input("IA",-72,-36)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Input("IB",-72,0)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Input("IC",-72,36)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Output("IALP",72,-36)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Output("IBET",72,0)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Output("ZER",72,36)
    {
    Cond = "!(Mode) && (Zero)"
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-44,-45,45,44)
   Cond = "(Mode==1)"
   Line(-71,-36,-44,-36)
   Text(-63,-34,"Alpha")
   Line(-50,-41,-44,-36)
   Line(-44,-36,-50,-30)
   Line(72,-36,45,-36)
   Text(63,-34,"A")
   Line(-71,0,-44,0)
   Text(-63,1,"Beta")
   Line(-50,-5,-44,0)
   Line(-44,0,-50,5)
   Line(72,0,45,0)
   Text(63,1,"B")
   Line(72,35,45,35)
   Text(63,37,"C")
   Cond = "(Mode==1) && (Zero==1)"
   Line(-71,35,-44,35)
   Text(-63,37,"Zero")
   Line(-50,30,-44,35)
   Line(-44,35,-50,41)
   Cond = "(Mode==1)"
   Text(0,-6,"AlphaBeta")
   Text(0,6,"to")
   Text(0,16,"ABC")
   Cond = "(Mode==0)"
   Line(-71,-36,-44,-36)
   Text(-63,-34,"A")
   Line(-50,-41,-44,-36)
   Line(-44,-36,-50,-30)
   Line(72,-36,45,-36)
   Text(63,-34,"Alpha")
   Line(-71,0,-44,0)
   Text(-63,1,"B")
   Line(-50,-5,-44,0)
   Line(-44,0,-50,5)
   Line(72,0,45,0)
   Text(63,1,"Beta")
   Line(-71,35,-44,35)
   Text(-63,37,"C")
   Line(-50,30,-44,35)
   Line(-44,35,-50,41)
   Cond = "(Mode==0) && (Zero==1)"
   Line(72,35,45,35)
   Text(63,37,"Zero")
   Cond = "(Mode==0)"
   Text(0,-6,"ABC")
   Text(0,6,"to")
   Text(0,16,"AlphaBeta")
   }

  Section(EMTDC)
   {
   FORTRAN = "\
#SUBROUTINE ALBEABC AlphaBeta transformation
!
!  AlphaBeta transformation:
!
#IF Mode==1
!  ------------------------------------
!  Transformation from AlphaBeta to ABC
!  ------------------------------------
       $IA = SQRT(2.0/3.0)*$IALP
       $IB = SQRT(2.0/3.0)*0.5*(-$IALP + SQRT(3.0)*$IBET)
       $IC = SQRT(2.0/3.0)*0.5*(-$IALP - SQRT(3.0)*$IBET)
#IF Zero==1
       $IA = $IA + SQRT(2.0/3.0)*$ZER/SQRT(2.0)
       $IB = $IB + SQRT(2.0/3.0)*$ZER/SQRT(2.0)
       $IC = $IC + SQRT(2.0/3.0)*$ZER/SQRT(2.0)
#ENDIF
#ELSE
!  ------------------------------------
!  Transformation from ABC to AlphaBeta
!  ------------------------------------
       $IALP = SQRT(2.0/3.0)*0.5*(2.0*$IA - $IB - $IC)
       $IBET = SQRT(2.0/3.0)*SQRT(3.0)*0.5*($IB - $IC)
#IF Zero==1
       $ZER  = SQRT(2.0/3.0)*($IA + $IB + $IC)/SQRT(2.0)
#ENDIF
#ENDIF"
   FILES = "\
cbpwm.f
"
   }
  }
 Module("CtrlSystem")
  {
  Desc = ""
  FileDate = 1144361525
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,White)
   Rectangle(-26,-36,25,36)
   Text(0,-10,"Control")
   Text(0,3,"System")
   Text(0,16,"Page")
   }


  Page(A/A4,Portrait,16,[597,467],5)
   {
   -Sticky-([54,594],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,594,234,666
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Calculation of  instantaneous real power based on alpha, beta quantities"
    }
   -Sticky-([252,594],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 252,594,432,666
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "After filtering of real power 'p' only ac component of the instantaneous  real power is left"
    }
   -Sticky-([54,882],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,882,234,954
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Calculation of instantaneous reactive power based on alpha, beta quantities"
    }
   -Sticky-([252,882],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 252,882,432,954
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "After filtering of reactive power 'q' only ac component of the instantaneous reactive power is left"
    }
   -Sticky-([594,450],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 594,450,774,522
    Alignment = 1
    Style = 1
    Arrow = 10
    Color = 0,15792890
    Text = "Calculation of  alpha, beta of current which become the reference current for active filter"
    }
   -Sticky-([882,774],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 882,774,990,846
    Alignment = 1
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Transformation of alpha, beta currents into phase currents"
    }
   -Sticky-([1026,450],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1026,450,1134,540
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Reference currents which are fed into current control of active filter"
    }
   -Sticky-([198,396],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 198,396,342,450
    Alignment = 1
    Style = 1
    Arrow = 192
    Color = 0,15792890
    Text = "Transformation of phase quantities into alpha, beta ones"
    }
   -Sticky-([864,918],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 864,918,1044,972
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
Control system of active filter:
Calculations of firing pulses"
    }
   -Sticky-([36,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 36,18,1188,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
SIMPLIFIED ACTIVE FILTER IN PARALLEL CONFIGURATION
Control System Subpage"
    }
   0.radiolink([162,108],4,0,10)
    {
    Source = "Main"
    Name = "V"
    dim = "3"
    Mode = "0"
    Type = "0"
    }
   -Wire-([162,108],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([180,216],6,0,-1)
    {
    Name = "Ia"
    }
   0.datalabel([180,252],6,0,-1)
    {
    Name = "Ib"
    }
   0.datalabel([180,288],6,0,-1)
    {
    Name = "Ic"
    }
   -Wire-([180,216],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([180,252],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([180,288],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.radiolink([162,216],4,0,90)
    {
    Source = "Main"
    Name = "Ia"
    dim = "1"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([162,252],4,0,100)
    {
    Source = "Main"
    Name = "Ib"
    dim = "1"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([162,288],4,0,110)
    {
    Source = "Main"
    Name = "Ic"
    dim = "1"
    Mode = "0"
    Type = "0"
    }
   0.datalabel([414,1278],6,0,-1)
    {
    Name = "g1"
    }
   0.datalabel([414,1386],6,0,-1)
    {
    Name = "g4"
    }
   0.datalabel([414,1458],6,0,-1)
    {
    Name = "g6"
    }
   0.datalabel([414,1350],6,0,-1)
    {
    Name = "g3"
    }
   0.datalabel([414,1314],6,0,-1)
    {
    Name = "g2"
    }
   0.datalabel([414,1422],6,0,-1)
    {
    Name = "g5"
    }
   -Wire-([432,1278],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([432,1314],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([432,1350],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([432,1386],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([432,1422],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([432,1458],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.radiolink([432,1278],0,0,630)
    {
    Source = "Main"
    Name = "g1"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([432,1314],0,0,620)
    {
    Source = "Main"
    Name = "g2"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([432,1350],0,0,610)
    {
    Source = "Main"
    Name = "g3"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([432,1386],0,0,600)
    {
    Source = "Main"
    Name = "g4"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([432,1422],0,0,590)
    {
    Source = "Main"
    Name = "g5"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([432,1458],0,0,580)
    {
    Source = "Main"
    Name = "g6"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.datalabel([882,144],0,0,-1)
    {
    Name = "IaRef"
    }
   0.pgb([918,144],0,22771792,700)
    {
    Name = "IaRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.04"
    Max = "0.04"
    }
   -Wire-([882,144],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([882,180],0,0,-1)
    {
    Name = "IbRef"
    }
   0.pgb([918,180],0,22772832,690)
    {
    Name = "IbRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([882,180],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([882,216],0,0,-1)
    {
    Name = "IcRef"
    }
   0.pgb([918,216],0,22773872,680)
    {
    Name = "IcRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([882,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([288,486],2,0,-1)
    {
    Name = "Ia"
    }
   0.datalabel([288,522],2,0,-1)
    {
    Name = "Ib"
    }
   0.datalabel([288,558],2,0,-1)
    {
    Name = "Ic"
    }
   -Wire-([288,486],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([288,522],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([288,558],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([486,486],2,0,-1)
    {
    Name = "Iaph"
    }
   0.datalabel([486,522],2,0,-1)
    {
    Name = "Ibta"
    }
   -Wire-([450,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([450,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .AlphaBeta_ABC([378,522],0,0,140)
    {
    Mode = "0"
    Zero = "0"
    }
   -Wire-([54,486],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([90,522],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([90,558],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([54,486],2,0,-1)
    {
    Name = "Va"
    }
   0.datalabel([54,522],2,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([54,558],2,0,-1)
    {
    Name = "Vc"
    }
   0.datalabel([252,486],2,0,-1)
    {
    Name = "Vaph"
    }
   0.datalabel([252,522],2,0,-1)
    {
    Name = "Vbta"
    }
   -Wire-([216,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([216,486],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .AlphaBeta_ABC([144,522],0,0,120)
    {
    Mode = "0"
    Zero = "0"
    }
   -Wire-([54,522],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([54,558],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([468,774],2,0,-1)
    {
    Name = "Pinst"
    }
   0.mult([126,738],0,0,170)
    {
    }
   0.datalabel([90,738],2,0,-1)
    {
    Name = "Iaph"
    }
   0.datalabel([90,774],2,0,-1)
    {
    Name = "Vaph"
    }
   0.mult([126,810],0,0,180)
    {
    }
   0.datalabel([90,810],2,0,-1)
    {
    Name = "Ibta"
    }
   0.datalabel([90,846],2,0,-1)
    {
    Name = "Vbta"
    }
   -Wire-([90,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([90,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([198,774],0,0,240)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([162,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([162,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.cmplx([342,774],0,0,250)
    {
    G = "1.0"
    DR = "0.2"
    F = "100.0 [Hz]"
    HP = "1"
    MP = "0"
    LP = "0"
    }
   0.pgb([270,774],3,50802112,670)
    {
    Name = "p_inst"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([414,774],3,25527040,660)
    {
    Name = "p_inst filtered"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([234,774],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([378,774],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.mult([126,1026],0,0,190)
    {
    }
   0.datalabel([90,1026],2,0,-1)
    {
    Name = "Iaph"
    }
   0.datalabel([90,1098],2,0,-1)
    {
    Name = "Ibta"
    }
   -Wire-([90,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([198,1062],0,0,260)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([162,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([162,1098],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([90,1062],2,0,-1)
    {
    Name = "Vbta"
    }
   -Wire-([234,1062],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.cmplx([342,1062],0,0,270)
    {
    G = "1.0"
    DR = "0.2"
    F = "100.0 [Hz]"
    HP = "1"
    MP = "0"
    LP = "0"
    }
   0.pgb([270,1062],3,25531928,650)
    {
    Name = "q_inst"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([414,1062],3,25533240,640)
    {
    Name = "q_inst filtered"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([378,1062],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.mult([126,1098],0,0,200)
    {
    }
   -Wire-([90,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([90,1134],2,0,-1)
    {
    Name = "Vaph"
    }
   0.datalabel([468,1062],2,0,-1)
    {
    Name = "Qinst"
    }
   0.fp_int([342,1422],0,0,540)
    {
    Type = "1"
    PNum = "1"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0 [deg]"
    min = "0.0 [deg]"
    BType = "0"
    PTime = "0.005 [s]"
    }
   0.const([180,1206],0,0,210)
    {
    Name = ""
    Value = "0.002"
    }
   0.datamerge([234,1278],4,0,220)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([216,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([270,1314],2,0,-1)
    {
    Name = "H_on"
    }
   0.datalabel([270,1386],2,0,-1)
    {
    Name = "H_off"
    }
   -Wire-([270,1350],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([306,1314],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([306,1350],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([306,1386],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([306,1422],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([234,1332],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   -Sticky-([126,1260],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 126,1260,198,1332
    Alignment = 1
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Hysteresis width for current PWM"
    }
   0.datalabel([828,468],2,0,-1)
    {
    Name = "Vaph"
    }
   0.mult([864,468],0,0,130)
    {
    }
   0.datalabel([864,504],0,0,-1)
    {
    Name = "Vaph"
    }
   0.sumjct([936,504],0,0,230)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([900,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.mult([864,540],0,0,150)
    {
    }
   0.datalabel([828,540],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([864,576],0,0,-1)
    {
    Name = "Vbta"
    }
   -Wire-([900,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([972,504],2,0,-1)
    {
    Name = "a2pb2"
    }
   0.mult([648,576],0,0,280)
    {
    }
   0.mult([648,648],0,0,290)
    {
    }
   -Wire-([612,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([612,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([720,612],0,0,320)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([684,576],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([684,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([612,576],2,0,-1)
    {
    Name = "Vaph"
    }
   0.datalabel([612,612],2,0,-1)
    {
    Name = "Pinst"
    }
   0.datalabel([612,648],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([612,684],2,0,-1)
    {
    Name = "Qinst"
    }
   0.mult([648,720],0,0,300)
    {
    }
   0.mult([648,792],0,0,310)
    {
    }
   -Wire-([612,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([612,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([720,756],0,0,340)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([684,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([684,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([612,756],2,0,-1)
    {
    Name = "Pinst"
    }
   0.datalabel([612,828],2,0,-1)
    {
    Name = "Qinst"
    }
   0.datalabel([612,720],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([612,792],2,0,-1)
    {
    Name = "Vaph"
    }
   0.div([792,612],0,0,330)
    {
    }
   0.div([792,756],0,0,350)
    {
    }
   0.datalabel([792,648],0,0,-1)
    {
    Name = "a2pb2"
    }
   0.datalabel([792,792],0,0,-1)
    {
    Name = "a2pb2"
    }
   -Wire-([828,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([864,756],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([828,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([864,648],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1008,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1008,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1008,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.gain([1080,648],0,0,400)
    {
    G = "GR"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([1116,720],2,0,-1)
    {
    Name = "IcRef"
    }
   0.datalabel([1116,684],2,0,-1)
    {
    Name = "IbRef"
    }
   0.datalabel([1116,648],2,0,-1)
    {
    Name = "IaRef"
    }
   0.gain([1080,684],0,0,370)
    {
    G = "GR"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([1080,720],0,0,380)
    {
    G = "GR"
    COM = "Gain"
    Dim = "1"
    }
   0.var([1044,594],0,24304128,160)
    {
    Name = "RefGain"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "-2"
    Value = "1.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([1116,594],2,0,-1)
    {
    Name = "GR"
    }
   -Wire-([1080,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .AlphaBeta_ABC([936,684],0,0,360)
    {
    Mode = "1"
    Zero = "0"
    }
   0.datalabel([954,1026],2,0,-1)
    {
    Name = "err_A"
    }
   0.datamerge([1044,1116],4,0,500)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   0.datalabel([954,1080],2,0,-1)
    {
    Name = "err_B"
    }
   0.datalabel([954,1134],2,0,-1)
    {
    Name = "err_C"
    }
   0.datalabel([882,1044],1,0,-1)
    {
    Name = "err_C"
    }
   0.gain([918,1044],0,0,460)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([918,1098],0,0,450)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([918,1152],0,0,490)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([882,1098],1,0,-1)
    {
    Name = "err_A"
    }
   0.datalabel([882,1152],1,0,-1)
    {
    Name = "err_B"
    }
   -Wire-([954,1026],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([954,1044],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([954,1080],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([954,1098],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([954,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([954,1152],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1026,1026],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1026,1134],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1008,1116],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1008,1044],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1026,1062],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1026,1116],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1080,1170],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([882,1206],1,0,-1)
    {
    Name = "err_A"
    }
   0.datamerge([1044,1296],4,0,480)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   0.datalabel([882,1260],1,0,-1)
    {
    Name = "err_B"
    }
   0.datalabel([882,1314],1,0,-1)
    {
    Name = "err_C"
    }
   0.datalabel([954,1224],0,0,-1)
    {
    Name = "err_C"
    }
   0.gain([918,1206],0,0,440)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([918,1260],0,0,420)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([918,1314],0,0,470)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.datalabel([954,1278],0,0,-1)
    {
    Name = "err_A"
    }
   0.datalabel([954,1332],0,0,-1)
    {
    Name = "err_B"
    }
   -Wire-([954,1206],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([954,1224],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([954,1260],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([954,1278],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([954,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([954,1332],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1026,1206],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1026,1314],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1008,1296],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1008,1224],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1026,1242],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1026,1296],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1080,1350],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([1080,1170],2,0,-1)
    {
    Name = "H_on"
    }
   0.datalabel([1080,1350],2,0,-1)
    {
    Name = "H_off"
    }
   -Sticky-([612,918],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 612,918,756,954
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Current error calculations"
    }
   0.sumjct([1026,1476],0,0,510)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([1026,1440],2,0,-1)
    {
    Name = "Ic"
    }
   0.datalabel([1026,1512],0,0,-1)
    {
    Name = "IcRef"
    }
   0.pgb([1062,1476],0,25617552,550)
    {
    Name = "IcP"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.sumjct([882,1476],0,0,520)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([882,1440],2,0,-1)
    {
    Name = "Ib"
    }
   0.datalabel([882,1512],0,0,-1)
    {
    Name = "IbRef"
    }
   0.pgb([918,1476],0,25620064,560)
    {
    Name = "IbP"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.sumjct([738,1476],0,0,530)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([738,1440],2,0,-1)
    {
    Name = "Ia"
    }
   0.datalabel([738,1512],0,0,-1)
    {
    Name = "IaRef"
    }
   0.pgb([774,1476],0,25622576,570)
    {
    Name = "IaP"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   -Sticky-([612,1332],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 612,1332,774,1386
    Alignment = 0
    Style = 1
    Arrow = 128
    Color = 0,15792890
    Text = "Theortical system current after 'correction' by reference current"
    }
   -Wire-([612,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([684,1134],0,0,390)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([720,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([684,1242],0,0,430)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([684,1062],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([684,1170],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([684,1278],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([720,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([684,1026],0,0,410)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "-1"
    G = "0"
    }
   0.datalabel([756,1026],2,0,-1)
    {
    Name = "err_A"
    }
   0.datalabel([756,1134],2,0,-1)
    {
    Name = "err_B"
    }
   0.datalabel([756,1242],2,0,-1)
    {
    Name = "err_C"
    }
   -Wire-([612,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([612,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([612,1026],0,0,-1)
    {
    Name = "IaRef"
    }
   0.datalabel([612,1134],0,0,-1)
    {
    Name = "IbRef"
    }
   0.datalabel([612,1242],0,0,-1)
    {
    Name = "IcRef"
    }
   0.datalabel([612,1062],0,0,-1)
    {
    Name = "IFa"
    }
   0.datalabel([612,1170],0,0,-1)
    {
    Name = "IFb"
    }
   0.datalabel([612,1278],0,0,-1)
    {
    Name = "IFc"
    }
   -ControlPanel-([684,126],0)
    {
    Name = "LOAD"
    Flags = 0
    State = 1
    Icon = 612,72
    Posn = 684,126
    Extents = 0,0,144,126
    Slider(24381560)
    Switch(24383520)
    }
   -ControlPanel-([594,126],0)
    {
    Name = "ACTIVE FILTER"
    Flags = 0
    State = 1
    Icon = 738,72
    Posn = 594,126
    Extents = 0,0,72,126
    Slider(24304128)
    }
   -Wire-([180,162],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.radiolink([162,162],4,0,50)
    {
    Source = "Main"
    Name = "IF"
    dim = "3"
    Mode = "0"
    Type = "0"
    }
   -Wire-([180,108],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.datatap([216,126],0,0,20)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([252,126],0,0,30)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([288,126],0,0,40)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([180,108],0,0,-1)
    {
    Name = "V"
    }
   0.datalabel([216,126],0,0,-1)
    {
    Name = "Va"
    }
   0.datalabel([252,126],0,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([288,126],0,0,-1)
    {
    Name = "Vc"
    }
   -Wire-([180,162],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.datatap([216,180],0,0,60)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([252,180],0,0,70)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([288,180],0,0,80)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([180,162],0,0,-1)
    {
    Name = "IF"
    }
   0.datalabel([216,180],0,0,-1)
    {
    Name = "IFa"
    }
   0.datalabel([252,180],0,0,-1)
    {
    Name = "IFb"
    }
   0.datalabel([288,180],0,0,-1)
    {
    Name = "IFc"
    }
   }
  }
 Module("RunTime")
  {
  Desc = ""
  FileDate = 1144361525
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,White)
   Rectangle(-25,-36,26,36)
   Line(-10,27,-10,2)
   Line(-14,24,15,24)
   Line(-10,23,-5,12)
   Line(-5,12,-2,19)
   Line(-2,19,2,8)
   Line(2,8,6,18)
   Line(6,18,12,3)
   Text(1,-15,"Graph")
   Text(1,-3,"Page")
   }


  Page(A/A4,Portrait,48,[597,467],100)
   {
   -Sticky-([36,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 36,18,1188,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
SIMPLIFIED ACTIVE FILTER IN PARALLEL CONFIGURATION
Graph Subpage"
    }
   -Plot-([90,90],0)
    {
    Title = "system & load current"
    Draw = 1
    Area = [0,0,468,648]
    Posn = [90,90]
    Icon = [-1,-1]
    Extents = 0,0,468,648
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,468,195],"Ph. A Current")
     {
     Options = 0
     Units = "kA"
     Curve(24385920,"ISa",0,,,)
     Curve(24431168,"Ia",1,,,)
     }
    Graph([0,195],[0,0,468,195],"Ph. B Current")
     {
     Options = 0
     Units = "kA"
     Curve(24388728,"ISb",0,,,)
     Curve(24434000,"Ib",1,,,)
     }
    Graph([0,390],[0,0,468,195],"Ph. C Current")
     {
     Options = 0
     Units = "kA"
     Curve(24391264,"ISc",0,,,)
     Curve(24436680,"Ic",1,,,)
     }
    }
   -Plot-([648,90],0)
    {
    Title = "phase A"
    Draw = 1
    Area = [0,0,450,648]
    Posn = [648,90]
    Icon = [-1,-1]
    Extents = 0,0,450,648
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,450,207],"Current")
     {
     Options = 0
     Units = "kA"
     Curve(22771792,"IaRef",0,,,)
     Curve(24439360,"IF",1,,-7,)
     }
    Graph([0,207],[0,0,450,207],"Current")
     {
     Options = 0
     Units = "kA"
     Curve(25622576,"IaP",0,,,)
     }
    PGraph([0,414],[0,0,450,171],"PolyGraph")
     {
     Options = 2
     Curve(24580192,"S4(1)",0,,,1)
     Curve(24449272,"S1(1)",0,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = " "
  FileDate = 1144361525
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,48,[597,467],100)
   {
   0.source3([216,396],0,0,40)
    {
    Name = "SRC"
    Type = "1"
    Ctrl = "0"
    MVA = "0.02 [MVA]"
    Vm = "0.2 [kV]"
    F = "$(freq)"
    Tc = "0.0 [s]"
    ZSeq = "0"
    Imp = "0"
    Exph = "0"
    View = "1"
    Term = "0"
    R1s = "0.002 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    R0p = "1.0 [ohm]"
    L0p = "0.1 [H]"
    Z0 = "1.0 [ohm]"
    Phi0 = "80.0 [deg]"
    Es = "0.2 [kV]"
    F0 = "$(freq)"
    Ph = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    VCtrl = "0"
    Vdes = "1.0 [pu]"
    Vbase = "230.0 [kV]"
    Tvm = "0.02 [s]"
    Tvc = "0.05 [s]"
    PCtrl = "0"
    Pdes = "1.0 [pu]"
    Tpm = "0.02 [s]"
    Tpc = "0.05 [s]"
    P = ""
    Q = ""
    V = ""
    Theta = ""
    Ia = "ISa"
    Ib = "ISb"
    Ic = "ISc"
    }
   0.ground([180,396],2,0,-1)
    {
    }
   -Wire-([252,396],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([540,306],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([378,306],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.var([702,432],2,24381560,90)
    {
    Name = "angle"
    Group = "Pulse Bridge Control"
    Display = "0"
    Max = "90"
    Min = "0"
    Value = "25.0"
    Units = "deg"
    Collect = "1"
    }
   -Wire-([378,360],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.var_switch([666,468],2,24383520,100)
    {
    Name = "blocking"
    Group = "Pulse Bridge Control"
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "deblk"
    Toff = "blk"
    }
   -Wire-([594,450],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([108,1044],0,0,-1)
    {
    Name = "ISa"
    }
   0.pgb([144,1044],0,24385920,210)
    {
    Name = "ISa"
    Group = "System Currents"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([108,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([108,1080],0,0,-1)
    {
    Name = "ISb"
    }
   0.pgb([144,1080],0,24388728,230)
    {
    Name = "ISb"
    Group = "System Currents"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([108,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([108,1116],0,0,-1)
    {
    Name = "ISc"
    }
   0.pgb([144,1116],0,24391264,250)
    {
    Name = "ISc"
    Group = "System Currents"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([108,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.ground([540,486],1,0,-1)
    {
    }
   0.datalabel([234,1044],0,0,-1)
    {
    Name = "Ia"
    }
   0.pgb([270,1044],0,24431168,220)
    {
    Name = "Ia"
    Group = "Load Currents"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([234,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([234,1080],0,0,-1)
    {
    Name = "Ib"
    }
   0.pgb([270,1080],0,24434000,240)
    {
    Name = "Ib"
    Group = "Load Currents"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([234,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([234,1116],0,0,-1)
    {
    Name = "Ic"
    }
   0.pgb([270,1116],0,24436680,260)
    {
    Name = "Ic"
    Group = "Load Currents"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([234,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([108,1206],0,0,-1)
    {
    Name = "IF"
    }
   0.pgb([144,1206],0,24439360,310)
    {
    Name = "IF"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.04"
    Max = "0.04"
    }
   -Wire-([108,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([144,1494],0,24441656,490)
    {
    Name = "ReactivePower"
    Group = "Power"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([144,1458],0,24443528,480)
    {
    Name = "RealPower"
    Group = "Power"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([234,1206],0,0,-1)
    {
    Name = "VFdc"
    }
   0.pgb([270,1206],0,24446080,330)
    {
    Name = "VFdc"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([234,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,594],0,0,-1)
    {
    Vertex="0,0;324,0"
    }
   -Wire-([738,810],0,0,-1)
    {
    Vertex="0,0;324,0"
    }
   0.voltmetergnd([1008,594],0,0,110)
    {
    Name = "VFdc"
    }
   0.pgb([144,1350],0,24449272,420)
    {
    Name = "S1(1)"
    Group = "Gate Pulse"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-1"
    Max = "2"
    }
   0.pgb([144,1386],0,24451160,500)
    {
    Name = "S1(2)"
    Group = "Gate Pulse"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([252,1350],0,24580192,440)
    {
    Name = "S4(1)"
    Group = "Gate Pulse"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-1"
    Max = "2"
    }
   0.pgb([252,1386],0,24582048,470)
    {
    Name = "S4(2)"
    Group = "Gate Pulse"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([522,702],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.inductor([738,396],1,0,-1)
    {
    L = "35 [mH]"
    }
   -Wire-([738,324],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   -Wire-([738,396],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.ground([738,486],1,0,-1)
    {
    }
   -Wire-([738,486],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.ammeter([702,306],0,0,30)
    {
    Name = "Idc"
    }
   0.resistor([738,324],1,0,-1)
    {
    R = "2.5 [ohm]"
    }
   0.nodeloop([378,396],0,0,60)
    {
    View = "1"
    }
   0.xfmr-3p2w([450,396],0,0,70)
    {
    Name = "T1"
    Tmva = "0.02 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "1"
    Lead = "1"
    Xl = "0.2 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "0.2 [kV]"
    V2 = "0.2 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = "Ia"
    ILB1 = "Ib"
    ILC1 = "Ic"
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([432,432],1,0,-1)
    {
    }
   0.xfmr-3p2w([360,702],0,0,-1)
    {
    Name = "T2"
    Tmva = "0.02 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "0"
    Lead = "1"
    Xl = "0.11 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "0.2 [kV]"
    V2 = "0.2 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([342,738],1,0,-1)
    {
    }
   0.ammeter([648,702],2,0,160)
    {
    Name = "IF"
    }
   0.ground([360,738],1,0,-1)
    {
    }
   0.resistor([522,702],2,0,-1)
    {
    R = "0.002 [ohm]"
    }
   0.datalabel([234,1242],0,0,-1)
    {
    Name = "IFdc"
    }
   0.pgb([270,1242],0,24618192,360)
    {
    Name = "IFdc"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([234,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1062,666],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.source1([1062,702],1,0,170)
    {
    Name = "dc"
    Type = "1"
    Ctrl = "0"
    Vm = "0.185 [kV]"
    F = "60.0 [Hz]"
    Tc = "0.0 [s]"
    Imp = "0"
    ACDC = "1"
    Exph = "0"
    Term = "0"
    Es = "132.79056 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "0.5 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "0.001 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = "IFdc"
    }
   0.peswitch([738,630],2,0,560)
    {
    L = "1"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch1"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([774,666],4,0,120)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id1"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([738,594],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([774,630],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([774,666],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.peswitch([846,630],2,0,550)
    {
    L = "3"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch3"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([882,666],4,0,140)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id3"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([846,594],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([882,630],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([882,666],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([846,666],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.peswitch([954,630],2,0,540)
    {
    L = "5"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch5"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([990,666],4,0,150)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id5"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([954,594],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([990,630],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([990,666],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([954,666],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.peswitch([738,738],2,0,530)
    {
    L = "4"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch4"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([774,774],4,0,180)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id4"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([738,666],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([774,738],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([774,774],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([738,774],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([846,738],2,0,520)
    {
    L = "6"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch6"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([882,774],4,0,190)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id6"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([882,738],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([882,774],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([846,774],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([954,738],2,0,510)
    {
    L = "2"
    Type = "2"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch2"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([990,774],4,0,200)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id2"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([990,738],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([990,774],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([954,774],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([684,720],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   -Wire-([684,702],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([684,684],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([702,666],0,0,-1)
    {
    Name = "g1"
    }
   0.datalabel([810,666],0,0,-1)
    {
    Name = "g3"
    }
   0.datalabel([918,666],0,0,-1)
    {
    Name = "g5"
    }
   0.datalabel([702,774],0,0,-1)
    {
    Name = "g4"
    }
   0.datalabel([810,774],0,0,-1)
    {
    Name = "g6"
    }
   0.datalabel([918,774],0,0,-1)
    {
    Name = "g2"
    }
   -Wire-([1062,810],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Sticky-([792,342],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 792,342,936,414
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
Load:
A 6 pulse rectifier as a source of harmonics"
    }
   -Sticky-([828,468],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 828,468,1044,558
    Alignment = 0
    Style = 1
    Arrow = 128
    Color = 0,15792890
    Text = "\
Simplification:
A dc source has been put in the place of dc capacitor, it has simplified a control system of active filter
  
  "
    }
   0.datalabel([216,1368],2,0,-1)
    {
    Name = "G4"
    }
   0.datalabel([108,1368],2,0,-1)
    {
    Name = "G1"
    }
   -Wire-([558,720],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.inductor([612,702],2,0,-1)
    {
    L = "1 [mH]"
    }
   0.capacitor([558,756],5,0,-1)
    {
    C = "0.1 [uF]"
    }
   0.ground([558,756],1,0,-1)
    {
    }
   0.datatap([144,1350],6,0,410)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "0"
    }
   0.datatap([144,1386],0,0,450)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "0"
    }
   -Wire-([108,1368],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datatap([252,1350],6,0,430)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "0"
    }
   0.datatap([252,1386],0,0,460)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "0"
    }
   -Wire-([216,1368],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([306,396],0,0,-1)
    {
    Vertex="0,0;0,306"
    }
   0.voltmetergnd([342,396],0,0,50)
    {
    Name = "V"
    }
   0.pin([306,396],0,0,-1)
    {
    }
   0.pin([738,684],0,0,-1)
    {
    }
   0.pin([846,702],0,0,-1)
    {
    }
   0.pin([954,720],0,0,-1)
    {
    }
   0.emtconst([666,396],2,0,80)
    {
    Name = "PI / 180"
    Value = "5"
    }
   0.mult([630,432],2,0,580)
    {
    }
   -Sticky-([72,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,72,612,198
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
 Reference:
  H. Fujita and H. Akagi,
  'A Practical Approach to Harmonic Compensation
  in Power Systems - Series Connection of Passive
  and Active Filters', IEEE Trans. on Ind.Applications,
  vol.27, No.6, Nov/Dec 1991, pp. 1020-1025
   "
    }
   .RunTime([180,252],0,0,20)
    {
    }
   -Sticky-([36,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 36,18,1188,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "SIMPLIFIED ACTIVE FILTER IN PARALLEL CONFIGURATION "
    }
   0.g6p200([540,396],0,0,590)
    {
    UP = "1"
    FP = "0"
    SNUB = "1"
    KV = "-2"
    View = "1"
    FR = "$(freq)"
    GP = "10.0"
    GI = "100.0"
    KP = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.001 [kV]"
    EBO = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    CD = "0.05 [uF]"
    RD = "5000.0 [ohm]"
    FPNM = ""
    VVolt = ""
    VCurr = ""
    SCurr = ""
    }
   0.annotation([144,1008],0,0,-1)
    {
    AL1 = "System Currents"
    AL2 = ""
    }
   0.annotation([270,1008],0,0,-1)
    {
    AL1 = "Load Currents"
    AL2 = ""
    }
   .CtrlSystem([108,252],0,0,10)
    {
    }
   0.datalabel([882,1152],2,0,-1)
    {
    Name = "Ia"
    }
   0.datalabel([882,1188],2,0,-1)
    {
    Name = "Ib"
    }
   0.datalabel([882,1224],2,0,-1)
    {
    Name = "Ic"
    }
   -Wire-([882,1152],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([882,1188],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([882,1224],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.radiolink([900,1152],0,0,340)
    {
    Source = "Main"
    Name = "Ia"
    dim = "1"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([900,1188],0,0,370)
    {
    Source = "Main"
    Name = "Ib"
    dim = "1"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([900,1224],0,0,390)
    {
    Source = "Main"
    Name = "Ic"
    dim = "1"
    Mode = "1"
    Type = "0"
    }
   0.datalabel([810,1080],2,0,-1)
    {
    Name = "g1"
    }
   0.datalabel([810,1188],2,0,-1)
    {
    Name = "g4"
    }
   0.datalabel([810,1260],2,0,-1)
    {
    Name = "g6"
    }
   0.datalabel([810,1152],2,0,-1)
    {
    Name = "g3"
    }
   0.datalabel([810,1116],2,0,-1)
    {
    Name = "g2"
    }
   0.datalabel([810,1224],2,0,-1)
    {
    Name = "g5"
    }
   -Wire-([792,1080],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([792,1116],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([792,1152],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([792,1188],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([792,1224],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([792,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.radiolink([792,1080],4,0,270)
    {
    Source = "CtrlSystem"
    Name = "g1"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([792,1116],4,0,290)
    {
    Source = "CtrlSystem"
    Name = "g2"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([792,1152],4,0,320)
    {
    Source = "CtrlSystem"
    Name = "g3"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([792,1188],4,0,350)
    {
    Source = "CtrlSystem"
    Name = "g4"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([792,1224],4,0,380)
    {
    Source = "CtrlSystem"
    Name = "g5"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([792,1260],4,0,400)
    {
    Source = "CtrlSystem"
    Name = "g6"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.datalabel([882,1116],2,0,-1)
    {
    Name = "IF"
    }
   -Wire-([882,1116],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.radiolink([900,1116],0,0,300)
    {
    Source = "Main"
    Name = "IF"
    dim = "3"
    Mode = "1"
    Type = "0"
    }
   -Wire-([486,396],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.breakout([648,702],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([684,666],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([684,738],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([882,1080],6,0,-1)
    {
    Name = "V"
    }
   0.radiolink([900,1080],0,0,280)
    {
    Source = "Main"
    Name = "V"
    dim = "3"
    Mode = "1"
    Type = "0"
    }
   -Wire-([900,1080],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.multimeter([414,702],0,0,130)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "1"
    MeasQ = "1"
    RMS = "0"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = ""
    P = "P"
    Q = "Q"
    Vrms = ""
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([432,702],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Sticky-([630,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 630,72,1170,180
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\

THIS CASE WILL NOT RUN ON THE STUDENT EDITION OF PSCAD BECAUSE IT HAS MORE THAN 15 NODES!  CONTACT support@pscad.com FOR MORE INFORMATION.  "
    }
   0.annotation([144,1170],0,0,-1)
    {
    AL1 = "Filter Currents"
    AL2 = ""
    }
   0.annotation([270,1170],0,0,-1)
    {
    AL1 = "Filter DC Quantities"
    AL2 = ""
    }
   0.annotation([144,1314],0,0,-1)
    {
    AL1 = "Firing Pulses"
    AL2 = ""
    }
   0.datalabel([108,1458],0,0,-1)
    {
    Name = "P"
    }
   -Wire-([108,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([108,1494],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([108,1494],0,0,-1)
    {
    Name = "Q"
    }
   0.unity([594,468],4,0,570)
    {
    IType = "2"
    OType = "1"
    }
   }
  }
 }

